IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'CG_FND_VERBA_GERACAO_EST_NF_ENT_IT')
BEGIN
	CREATE TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT](
		[CD_EMP] [int] NOT NULL,
		[CD_FND_VERBA] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[QT_PROD] [money] NOT NULL,
		[VLR_PROD_VERBA] [money] NOT NULL,
		[VLR_PROD_VERBA_LIMITE] [money] NOT NULL,
		[VLR_PROD_VERBA_MOVIMENTO] [money] NOT NULL,
		[VLR_PROD_VERBA_USADA] [money] NOT NULL,
		[ORDEM] [int] NOT NULL,
		[VLR_PROD_VERBA_SALDO] [money] NOT NULL,
	 CONSTRAINT [PK_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FND_VERBA] ASC,
		[CD_FILIAL] ASC,
		[CD_NF] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 100) ON [PRIMARY]
	) ON [PRIMARY]
end
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_EMP') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_FILIAL') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_VD') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_VD]  DEFAULT ((0)) FOR [CD_NF]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_IT') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CD_IT]  DEFAULT ((0)) FOR [CD_PROD]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_QT_PROD') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_QT_PROD]  DEFAULT ((0)) FOR [QT_PROD]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA]  DEFAULT ((0)) FOR [VLR_PROD_VERBA]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_LIMITE') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_LIMITE]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_LIMITE]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_MOVIMENTO') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_MOVIMENTO]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_MOVIMENTO]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_USADA') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_USADA]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_USADA]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_ORDEM') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_ORDEM]  DEFAULT ((0)) FOR [ORDEM]
GO

IF OBJECT_ID('DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_SALDO') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_VLR_PROD_VERBA_SALDO]  DEFAULT ((0)) FOR [VLR_PROD_VERBA_SALDO]
GO


IF OBJECT_ID('FK_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CG_FND_VERBA_CD_FND_VERBA') IS NULL 
ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CG_FND_VERBA_CD_FND_VERBA] FOREIGN KEY([CD_FND_VERBA], [CD_EMP])
REFERENCES [dbo].[CG_FND_VERBA] ([CD_FND_VERBA], [CD_EMP])

ALTER TABLE [dbo].[CG_FND_VERBA_GERACAO_EST_NF_ENT_IT] CHECK CONSTRAINT [FK_CG_FND_VERBA_GERACAO_EST_NF_ENT_IT_CG_FND_VERBA_CD_FND_VERBA]


